/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.internal.core.index;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.model.AliasElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.core.model.UserAgentElement;
import com.aptana.js.internal.core.index.IJSCAModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSCAModel
implements IJSCAModel {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private Map<String, TypeElement> typesByName;
    private JSONObject root;
    private List<AliasElement> aliases;
    private List<TypeElement> types;

    public JSCAModel(JSONObject json) {
        this.root = json;
    }

    @Override
    public synchronized List<AliasElement> getAliases() {
        if (this.aliases == null) {
            List array = (List)this.root.get((Object)"aliases");
            this.aliases = Collections.unmodifiableList(CollectionsUtil.map((Collection)array, (IMap)new IMap<Object, AliasElement>(){

                public AliasElement map(Object item) {
                    JSONObject alias = (JSONObject)item;
                    AliasElement ae = new AliasElement();
                    ae.setDescription((String)alias.get((Object)"description"));
                    ae.setName((String)alias.get((Object)"name"));
                    ae.setType((String)alias.get((Object)"type"));
                    return ae;
                }
            }));
        }
        this.cleanup();
        return this.aliases;
    }

    private void cleanup() {
        if (this.aliases != null && this.types != null) {
            this.typesByName = null;
            this.root = null;
        }
    }

    @Override
    public synchronized List<TypeElement> getTypes() {
        if (this.types == null) {
            this.types = Collections.unmodifiableList(this.doGetTypes());
        }
        this.cleanup();
        return this.types;
    }

    private List<TypeElement> doGetTypes() {
        List array = (List)this.root.get((Object)"types");
        if (CollectionsUtil.isEmpty((Collection)array)) {
            return Collections.emptyList();
        }
        int length = array.size();
        this.typesByName = new HashMap<String, TypeElement>(length);
        int i = 0;
        while (i < length) {
            List<UserAgentElement> userAgents;
            String propertyName;
            PropertyElement property;
            TypeElement currentType = this.createType((JSONObject)array.get(i));
            String typeName = currentType.getName();
            String namespace = this.getNamespace(typeName);
            this.setIsInternal(typeName, currentType.isInternal());
            this.hideNamespace(namespace);
            TypeElement namespaceType = this.getType(namespace);
            if (namespaceType != null && (property = namespaceType.getProperty(propertyName = typeName.substring(namespace.length() + 1))) != null && !CollectionsUtil.isEmpty(userAgents = currentType.getUserAgents())) {
                for (UserAgentElement userAgent : userAgents) {
                    property.addUserAgent(userAgent);
                }
            }
            ++i;
        }
        return new ArrayList<TypeElement>(this.typesByName.values());
    }

    protected TypeElement createType(JSONObject json) {
        TypeElement currentType;
        String globalPrefix;
        String typeName = (String)json.get((Object)"name");
        if (typeName.startsWith(globalPrefix = "Global.")) {
            typeName = typeName.substring(globalPrefix.length());
        }
        if (this.typesByName.containsKey(typeName)) {
            currentType = this.typesByName.get(typeName);
        } else {
            currentType = new TypeElement();
            currentType.setName(typeName);
        }
        currentType.fromJSON((Map)json);
        this.typesByName.put(typeName, currentType);
        String[] parts = DOT_PATTERN.split(typeName);
        if (parts.length > 1) {
            String accumulatedName = parts[0];
            TypeElement type = this.getType(accumulatedName);
            int i = 1;
            while (i < parts.length) {
                String pName = parts[i];
                accumulatedName = String.valueOf(accumulatedName) + "." + pName;
                PropertyElement property = type.getProperty(pName);
                if (property == null) {
                    property = new PropertyElement();
                    property.setName(pName);
                    property.setIsClassProperty(true);
                    property.addType(accumulatedName);
                    type.addProperty(property);
                }
                this.typesByName.put(type.getName(), type);
                type = this.getType(accumulatedName);
                ++i;
            }
        }
        return currentType;
    }

    private TypeElement getType(String typeName) {
        TypeElement result = this.typesByName.get(typeName);
        if (result == null) {
            result = new TypeElement();
            result.setName(typeName);
        }
        return result;
    }

    protected void setIsInternal(String typeName, boolean isInternal) {
        String namespace = this.getNamespace(typeName);
        if (!StringUtil.isEmpty((String)namespace)) {
            String name;
            PropertyElement property;
            TypeElement namespaceType = this.typesByName.get(namespace);
            if (namespaceType != null && (property = namespaceType.getProperty(name = typeName.substring(namespace.length() + 1))) != null) {
                property.setIsInternal(isInternal);
            }
        } else {
            TypeElement type = this.typesByName.get(typeName);
            type.setIsInternal(isInternal);
        }
    }

    private String getNamespace(String typeName) {
        int index = typeName.lastIndexOf(46);
        return index != -1 ? typeName.substring(0, index) : "";
    }

    protected void hideNamespace(String namespace) {
        while (!StringUtil.isEmpty((String)namespace)) {
            TypeElement type = this.typesByName.get(namespace);
            if (type != null) {
                boolean isInternal = true;
                for (PropertyElement property : type.getProperties()) {
                    if (property.isInternal()) continue;
                    isInternal = false;
                    break;
                }
                this.setIsInternal(namespace, isInternal);
            } else {
                this.log("Unrecognized namespace in JSCAModel#hideNamespace: " + namespace);
            }
            namespace = this.getNamespace(namespace);
        }
    }

    protected void log(String message) {
        if (Platform.inDevelopmentMode()) {
            System.out.println(message);
        } else {
            IdeLog.logError((Plugin)JSCorePlugin.getDefault(), (String)message);
        }
    }
}

